import { world, system, Block, ItemStack, BlockPermutation } from '@minecraft/server'

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:copper_bars', {
        onTick(data) {
            const { block, player } = data
            const north = block.permutation.getState("v360:connect_north")
            const south = block.permutation.getState("v360:connect_south")
            const west = block.permutation.getState("v360:connect_west")
            const east = block.permutation.getState("v360:connect_east")
            if (north || south || west || east || !north || !south || !west || !east) {
                const chain = BlockPermutation.resolve('v360:exposed_copper_bar_block', { "v360:connect_north": north, "v360:connect_south": south, "v360:connect_west": west, "v360:connect_east": east });
                block.setPermutation(chain);
            }
        },
        onPlayerInteract(data) {
            const { block, player } = data
            const north = block.permutation.getState("v360:connect_north")
            const south = block.permutation.getState("v360:connect_south")
            const west = block.permutation.getState("v360:connect_west")
            const east = block.permutation.getState("v360:connect_east")
            const equipment = player.getComponent('equippable');
            const selectedItem = equipment.getEquipment('Mainhand');
            if ((north || south || west || east || !north || !south || !west || !east) && selectedItem?.typeId === 'minecraft:honeycomb') {
                const bar = BlockPermutation.resolve('v360:waxed_copper_bar_block', { "v360:connect_north": north, "v360:connect_south": south, "v360:connect_west": west, "v360:connect_east": east });
                const { x, y, z } = block.location
                block.setPermutation(bar);
                block.dimension.runCommand(`particle v360:wax ${x} ${y + 0.5} ${z}`)
                block.dimension.playSound("copper.wax.on", block.location)
                if (player.getGameMode() !== "creative") {
                    player.runCommandAsync('clear @s minecraft:honeycomb 0 1')
                }
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:exposed_copper_bars', {
        onTick(data) {
            const { block, player } = data
            const north = block.permutation.getState("v360:connect_north")
            const south = block.permutation.getState("v360:connect_south")
            const west = block.permutation.getState("v360:connect_west")
            const east = block.permutation.getState("v360:connect_east")
            if (north || south || west || east || !north || !south || !west || !east) {
                const chain = BlockPermutation.resolve('v360:weathered_copper_bar_block', { "v360:connect_north": north, "v360:connect_south": south, "v360:connect_west": west, "v360:connect_east": east });
                block.setPermutation(chain);
            }
        },
        onPlayerInteract(data) {
            const { block, player } = data
            const north = block.permutation.getState("v360:connect_north")
            const south = block.permutation.getState("v360:connect_south")
            const west = block.permutation.getState("v360:connect_west")
            const east = block.permutation.getState("v360:connect_east")
            const equipment = player.getComponent('equippable');
            const selectedItem = equipment.getEquipment('Mainhand');
            if ((north || south || west || east || !north || !south || !west || !east) && selectedItem?.typeId === 'minecraft:honeycomb') {
                const bar = BlockPermutation.resolve('v360:waxed_exposed_copper_bar_block', { "v360:connect_north": north, "v360:connect_south": south, "v360:connect_west": west, "v360:connect_east": east })
                const { x, y, z } = block.location
                block.setPermutation(bar);
                block.dimension.runCommand(`particle v360:wax ${x} ${y + 0.5} ${z}`)
                block.dimension.playSound("copper.wax.on", block.location)
                if (player.getGameMode() !== "creative") {
                    player.runCommandAsync('clear @s minecraft:honeycomb 0 1')
                }
            }

            else if ((north || south || west || east || !north || !south || !west || !east) && selectedItem?.hasTag('minecraft:is_axe')) {
                const bar = BlockPermutation.resolve('v360:copper_bar_block', { "v360:connect_north": north, "v360:connect_south": south, "v360:connect_west": west, "v360:connect_east": east });
                const { x, y, z } = block.location
                block.setPermutation(bar);
                block.dimension.runCommand(`particle v360:oxidization_off ${x} ${y + 0.5} ${z}`)
                block.dimension.playSound("copper.wax.off", block.location)
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:weathered_copper_bars', {
        onTick(data) {
            const { block, player } = data
            const north = block.permutation.getState("v360:connect_north")
            const south = block.permutation.getState("v360:connect_south")
            const west = block.permutation.getState("v360:connect_west")
            const east = block.permutation.getState("v360:connect_east")
            if ((north || south || west || east || !north || !south || !west || !east)) {
                const chain = BlockPermutation.resolve('v360:oxidized_copper_bar_block', { "v360:connect_north": north, "v360:connect_south": south, "v360:connect_west": west, "v360:connect_east": east });
                block.setPermutation(chain);
            }
        },
        onPlayerInteract(data) {
            const { block, player } = data
            const north = block.permutation.getState("v360:connect_north")
            const south = block.permutation.getState("v360:connect_south")
            const west = block.permutation.getState("v360:connect_west")
            const east = block.permutation.getState("v360:connect_east")
            const equipment = player.getComponent('equippable');
            const selectedItem = equipment.getEquipment('Mainhand');
            if ((north || south || west || east || !north || !south || !west || !east) && selectedItem?.typeId === 'minecraft:honeycomb') {
                const bar = BlockPermutation.resolve('v360:waxed_weathered_copper_bar_block', { "v360:connect_north": north, "v360:connect_south": south, "v360:connect_west": west, "v360:connect_east": east })
                const { x, y, z } = block.location
                block.setPermutation(bar);
                block.dimension.runCommand(`particle v360:wax ${x} ${y + 0.5} ${z}`)
                block.dimension.playSound("copper.wax.on", block.location)
                if (player.getGameMode() !== "creative") {
                    player.runCommandAsync('clear @s minecraft:honeycomb 0 1')
                }
            }

            else if ((north || south || west || east || !north || !south || !west || !east) && selectedItem?.hasTag('minecraft:is_axe')) {
                const bar = BlockPermutation.resolve('v360:exposed_copper_bar_block', { "v360:connect_north": north, "v360:connect_south": south, "v360:connect_west": west, "v360:connect_east": east });
                const { x, y, z } = block.location
                block.setPermutation(bar);
                block.dimension.runCommand(`particle v360:oxidization_off ${x} ${y + 0.5} ${z}`)
                block.dimension.playSound("copper.wax.off", block.location)
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:oxidized_copper_bars', {
        onPlayerInteract(data) {
            const { block, player } = data
            const north = block.permutation.getState("v360:connect_north")
            const south = block.permutation.getState("v360:connect_south")
            const west = block.permutation.getState("v360:connect_west")
            const east = block.permutation.getState("v360:connect_east")
            const equipment = player.getComponent('equippable');
            const selectedItem = equipment.getEquipment('Mainhand');
            if ((north || south || west || east || !north || !south || !west || !east) && selectedItem?.typeId === 'minecraft:honeycomb') {
                const bar = BlockPermutation.resolve('v360:waxed_oxidized_copper_bar_block', { "v360:connect_north": north, "v360:connect_south": south, "v360:connect_west": west, "v360:connect_east": east });
                const { x, y, z } = block.location
                block.setPermutation(bar);
                block.dimension.runCommand(`particle v360:wax ${x} ${y + 0.5} ${z}`)
                block.dimension.playSound("copper.wax.on", block.location)
                if (player.getGameMode() !== "creative") {
                    player.runCommandAsync('clear @s minecraft:honeycomb 0 1')
                }
            }
            else if ((north || south || west || east || !north || !south || !west || !east) && selectedItem?.hasTag('minecraft:is_axe')) {
                const bar = BlockPermutation.resolve('v360:weathered_copper_bar_block', { "v360:connect_north": north, "v360:connect_south": south, "v360:connect_west": west, "v360:connect_east": east });
                const { x, y, z } = block.location
                block.setPermutation(bar);
                block.dimension.runCommand(`particle v360:oxidization_off ${x} ${y + 0.5} ${z}`)
                block.dimension.playSound("copper.wax.off", block.location)
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:waxed_copper_bars', {
        onPlayerInteract(data) {
            const { block, player } = data
            const north = block.permutation.getState("v360:connect_north")
            const south = block.permutation.getState("v360:connect_south")
            const west = block.permutation.getState("v360:connect_west")
            const east = block.permutation.getState("v360:connect_east")
            const equipment = player.getComponent('equippable');
            const selectedItem = equipment.getEquipment('Mainhand');
            if ((north || south || west || east || !north || !south || !west || !east) && selectedItem?.hasTag('minecraft:is_axe')) {
                const bar = BlockPermutation.resolve('v360:copper_bar_block', { "v360:connect_north": north, "v360:connect_south": south, "v360:connect_west": west, "v360:connect_east": east });
                const { x, y, z } = block.location
                block.setPermutation(bar);
                block.dimension.runCommand(`particle v360:wax_off ${x} ${y + 0.5} ${z}`)
                block.dimension.playSound("copper.wax.off", block.location)
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:waxed_exposed_copper_bars', {
        onPlayerInteract(data) {
            const { block, player } = data
            const north = block.permutation.getState("v360:connect_north")
            const south = block.permutation.getState("v360:connect_south")
            const west = block.permutation.getState("v360:connect_west")
            const east = block.permutation.getState("v360:connect_east")
            const equipment = player.getComponent('equippable');
            const selectedItem = equipment.getEquipment('Mainhand');
            if ((north || south || west || east || !north || !south || !west || !east) && selectedItem?.hasTag('minecraft:is_axe')) {
                const bar = BlockPermutation.resolve('v360:exposed_copper_bar_block', { "v360:connect_north": north, "v360:connect_south": south, "v360:connect_west": west, "v360:connect_east": east });
                const { x, y, z } = block.location
                block.setPermutation(bar);
                block.dimension.runCommand(`particle v360:wax_off ${x} ${y + 0.5} ${z}`)
                block.dimension.playSound("copper.wax.off", block.location)
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:waxed_weathered_copper_bars', {
        onPlayerInteract(data) {
            const { block, player } = data
            const north = block.permutation.getState("v360:connect_north")
            const south = block.permutation.getState("v360:connect_south")
            const west = block.permutation.getState("v360:connect_west")
            const east = block.permutation.getState("v360:connect_east")
            const equipment = player.getComponent('equippable');
            const selectedItem = equipment.getEquipment('Mainhand');
            if ((north || south || west || east || !north || !south || !west || !east) && selectedItem?.hasTag('minecraft:is_axe')) {
                const bar = BlockPermutation.resolve('v360:weathered_copper_bar_block', { "v360:connect_north": north, "v360:connect_south": south, "v360:connect_west": west, "v360:connect_east": east });
                const { x, y, z } = block.location
                block.setPermutation(bar);
                block.dimension.runCommand(`particle v360:wax_off ${x} ${y + 0.5} ${z}`)
                block.dimension.playSound("copper.wax.off", block.location)
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:waxed_oxidized_copper_bars', {
        onPlayerInteract(data) {
            const { block, player } = data
            const north = block.permutation.getState("v360:connect_north")
            const south = block.permutation.getState("v360:connect_south")
            const west = block.permutation.getState("v360:connect_west")
            const east = block.permutation.getState("v360:connect_east")
            const equipment = player.getComponent('equippable');
            const selectedItem = equipment.getEquipment('Mainhand');
            if ((north || south || west || east || !north || !south || !west || !east) && selectedItem?.hasTag('minecraft:is_axe')) {
                const bar = BlockPermutation.resolve('v360:oxidized_copper_bar_block', { "v360:connect_north": north, "v360:connect_south": south, "v360:connect_west": west, "v360:connect_east": east });
                const { x, y, z } = block.location
                block.setPermutation(bar);
                block.dimension.runCommand(`particle v360:wax_off ${x} ${y + 0.5} ${z}`)
                block.dimension.playSound("copper.wax.off", block.location)
            }
        }
    })
})

const barTag = 'v360:is_bar'

export class bars {
    static update_Bar_States(Bar) {
        let north = undefined;
        try {
            north = Bar.north(1);
        } catch { }
        let south = undefined;
        try {
            south = Bar.south(1);
        } catch { }
        let east = undefined;
        try {
            east = Bar.east(1);
        } catch { }
        let west = undefined;
        try {
            west = Bar.west(1);
        } catch { }
        const blocks = [
            { block: north, side: "north" },
            { block: south, side: "south" },
            { block: east, side: "east" },
            { block: west, side: "west" },
        ];
        for (const blockData of blocks) {
            if (blockData.block != undefined) {
                if (!(blockData.block.isLiquid || blockData.block.isAir || blockData.block.permutation.matches('minecraft:snow_layer') || blockData.block.permutation.matches('minecraft:red_flower') || blockData.block.permutation.matches('minecraft:tallgrass') || blockData.block.permutation.matches('minecraft:double_plant') || blockData.block.permutation.matches('minecraft:anvil') || blockData.block.permutation.matches('minecraft:scaffolding') || blockData.block.permutation.matches('minecraft:decorated_pot'))) {
                    Bar.setPermutation(Bar.permutation.withState("v360:connect_" + blockData.side, true));
                } else {
                    Bar.setPermutation(Bar.permutation.withState("v360:connect_" + blockData.side, false));
                }
            } else {
                Bar.setPermutation(Bar.permutation.withState("v360:connect_" + blockData.side, false));
            }
        }
    }
    static updateBarsAround(Block) {
        let north = undefined;
        try {
            north = Block.north(1);
        } catch { }
        let south = undefined;
        try {
            south = Block.south(1);
        } catch { }
        let east = undefined;
        try {
            east = Block.east(1);
        } catch { }
        let west = undefined;
        try {
            west = Block.west(1);
        } catch { }
        const blocks = [Block, north, south, east, west];
        for (const block of blocks) {
            if (block != undefined) {
                if (block.hasTag(barTag)) this.update_Bar_States(block);
            }
        }
    }
}